/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2020  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package test;

import nl.tudelft.labracore.api.*;
import nl.tudelft.queue.cache.*;

import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BaseMockConfig {
	@MockBean
	private AssignmentCacheManager assignmentCacheManager;

	@MockBean
	private EditionCacheManager editionCacheManager;

	@MockBean
	private EditionCollectionCacheManager editionCollectionCacheManager;

	@MockBean
	private EditionRolesCacheManager editionRolesCacheManager;

	@MockBean
	private ModuleCacheManager moduleCacheManager;

	@MockBean
	private PersonCacheManager personCacheManager;

	@MockBean
	private RoleCacheManager roleCacheManager;

	@MockBean
	private RoomCacheManager roomCacheManager;

	@MockBean
	private SessionCacheManager sessionCacheManager;

	@MockBean
	private StudentGroupCacheManager studentGroupCacheManager;

	@MockBean
	private AssignmentControllerApi assignmentControllerApi;

	@MockBean
	private AuthorizationControllerApi aApi;

	@MockBean
	private EditionControllerApi editionControllerApi;

	@MockBean
	private EditionCollectionControllerApi editionCollectionControllerApi;

	@MockBean
	private SessionControllerApi sessionControllerApi;

	@MockBean
	private PersonControllerApi personControllerApi;

	@MockBean
	private RoleControllerApi roleControllerApi;

	@MockBean
	private StudentGroupControllerApi studentGroupControllerApi;

}
