/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.cache;

import java.util.List;

import nl.tudelft.labracore.api.ProgramControllerApi;
import nl.tudelft.labracore.api.dto.ProgramDetailsDTO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class ProgramCacheManager extends CoreCacheManager<Long, ProgramDetailsDTO> {

	@Autowired
	private ProgramControllerApi api;

	@Override
	protected List<ProgramDetailsDTO> fetch(List<Long> longs) {
		return api.getAllProgramsById(longs).collectList().block();
	}

	@Override
	protected Long getId(ProgramDetailsDTO programDetailsDTO) {
		return programDetailsDTO.getId();
	}
}
