/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.config;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import nl.tudelft.queue.dialect.AuthenticatedPersonDialect;
import nl.tudelft.queue.dialect.ProfileDialect;
import nl.tudelft.queue.repository.ProfileRepository;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.extras.springsecurity5.dialect.SpringSecurityDialect;

@Configuration
public class ThymeleafConfig {
	@Bean
	public Java8TimeDialect java8TimeDialect() {
		return new Java8TimeDialect();
	}

	@Bean
	public SpringSecurityDialect securityDialect() {
		return new SpringSecurityDialect();
	}

	@Bean
	public AuthenticatedPersonDialect authenticatedPersonDialect() {
		return new AuthenticatedPersonDialect();
	}

	@Bean
	public ProfileDialect profileDialect(ProfileRepository profileRepository) {
		return new ProfileDialect(profileRepository);
	}

	/**
	 * Checks whether today is the day.
	 *
	 * @return {@code true} when today is the day, {@code false} if today is not the day.
	 */
	public boolean isTheDay() {
		return DateTimeFormatter.ofPattern("dd-MM").format(LocalDateTime.now()).equals("01-04");
	}
}
