/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.controller;

import lombok.AllArgsConstructor;
import nl.tudelft.labracore.lib.security.user.AuthenticatedPerson;
import nl.tudelft.labracore.lib.security.user.Person;
import nl.tudelft.queue.dto.patch.ProfilePatchDTO;
import nl.tudelft.queue.repository.ProfileRepository;

import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@AllArgsConstructor
@RequestMapping("profile")
@Controller("queueProfileController")
public class ProfileController {

	private ProfileRepository profileRepository;

	/**
	 * Updates the user's profile.
	 *
	 * @param  person The person whose profile to update
	 * @param  patch  The patch with new data
	 * @return        Empty http response
	 */
	@ResponseBody
	@PostMapping("update")
	public ResponseEntity<Void> updateProfile(@AuthenticatedPerson Person person,
			@RequestBody ProfilePatchDTO patch) {
		profileRepository.save(patch.apply(profileRepository.findProfileForPerson(person)));
		return ResponseEntity.ok().build();
	}

}
