/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.dto.patch.embeddables;

import static nl.tudelft.librador.SpringContext.getBean;

import lombok.*;
import lombok.experimental.SuperBuilder;
import nl.tudelft.librador.dto.patch.Patch;
import nl.tudelft.queue.dto.patch.constraints.ClusterConstraintPatchDTO;
import nl.tudelft.queue.dto.patch.constraints.ModuleDivisionConstraintPatchDTO;
import nl.tudelft.queue.model.QueueSession;
import nl.tudelft.queue.model.constraints.ClusterConstraint;
import nl.tudelft.queue.model.constraints.ModuleDivisionConstraint;
import nl.tudelft.queue.repository.LabRequestConstraintRepository;

import org.springframework.util.CollectionUtils;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class LabRequestConstraintsPatchDTO extends Patch<QueueSession<?>> {
	@Builder.Default
	private ClusterConstraintPatchDTO clusterConstraint = new ClusterConstraintPatchDTO();
	@Builder.Default
	private ModuleDivisionConstraintPatchDTO moduleDivisionConstraint = new ModuleDivisionConstraintPatchDTO();

	@Override
	protected void applyOneToOne() {
		var constraints = data.getConstraints();

		if (CollectionUtils.isEmpty(clusterConstraint.getClusters())) {
			if (data.getConstraints().getClusterConstraint() != null) {
				getBean(LabRequestConstraintRepository.class)
						.delete(data.getConstraints().getClusterConstraint());
				data.getConstraints().setClusterConstraint(null);
			}
		} else if (constraints.getClusterConstraint() == null) {
			constraints.setClusterConstraint(ClusterConstraint.builder()
					.session(data).clusters(clusterConstraint.getClusters()).build());
		} else {
			clusterConstraint.apply(constraints.getClusterConstraint());
		}

		if (CollectionUtils.isEmpty(moduleDivisionConstraint.getDivisions())) {
			if (data.getConstraints().getModuleDivisionConstraint() != null) {
				getBean(LabRequestConstraintRepository.class)
						.delete(data.getConstraints().getModuleDivisionConstraint());
				data.getConstraints().setModuleDivisionConstraint(null);
			}
		} else if (constraints.getModuleDivisionConstraint() == null) {
			constraints.setModuleDivisionConstraint(ModuleDivisionConstraint.builder()
					.session(data).divisions(moduleDivisionConstraint.getDivisions()).build());
		} else {
			moduleDivisionConstraint.apply(constraints.getModuleDivisionConstraint());
		}
	}

	@Override
	protected void validate() {
	}
}
