/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.realtime.messages;

import static nl.tudelft.librador.SpringContext.getBean;

import lombok.*;
import nl.tudelft.queue.cache.PersonCacheManager;
import nl.tudelft.queue.model.enums.RequestStatus;
import nl.tudelft.queue.model.events.RequestTakenEvent;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class RequestTakenMessage extends RequestStatusUpdateMessage<RequestTakenEvent> {
	private static final long serialVersionUID = -2710218413754443043L;

	private String takenBy;

	@Override
	public void postApply() {
		super.postApply();

		takenBy = getBean(PersonCacheManager.class).getRequired(data.getAssistant()).getDisplayName();
	}

	@Override
	public RequestStatus getStatus() {
		return RequestStatus.PROCESSING;
	}

	@Override
	public String getType() {
		return "request-taken";
	}
}
