/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.repository;

import static java.time.LocalDateTime.now;

import java.util.List;

import nl.tudelft.queue.model.ClosableTimeSlot;
import nl.tudelft.queue.model.QClosableTimeSlot;

import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.lang.NonNull;

import com.querydsl.core.types.Predicate;

public interface ClosableTimeSlotRepository
		extends JpaRepository<ClosableTimeSlot, Long>, QuerydslPredicateExecutor<ClosableTimeSlot> {
	QClosableTimeSlot qcts = QClosableTimeSlot.closableTimeSlot;

	@NonNull
	@Override
	List<ClosableTimeSlot> findAll(@NonNull Predicate predicate);

	@NonNull
	@Override
	List<ClosableTimeSlot> findAll(@NonNull Predicate predicate, @NonNull Sort sort);

	/**
	 * Finds all {@link ClosableTimeSlot}s that are still active and can be closed for evaluation. These time
	 * slots are now defined as all slots that have passed more than 15 minutes ago.
	 *
	 * @return All {@link ClosableTimeSlot}s that can now be closed.
	 */
	default List<ClosableTimeSlot> findAllClosablyActive() {
		return findAll(qcts.active.isTrue()
				.and(qcts.slot.closesAt.before(now().minusMinutes(15L))));
	}
}
