/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package e2e;

import java.nio.file.Paths;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

import com.microsoft.playwright.Page;
import com.microsoft.playwright.options.AriaRole;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public class ExampleEndToEndTest extends EndToEndTest {

	@Test
	void takeScreenShot() {
		page.navigate("localhost:8081");
		page.screenshot(new Page.ScreenshotOptions().setPath(Paths.get("build/screenshots/test.png")));
	}

	@Test
	void login() {
		page.navigate("http://localhost:8081/");
		page.getByRole(AriaRole.LINK, new Page.GetByRoleOptions().setName("Click here to log in")).click();
		page.getByLabel("Username").click();
		page.getByLabel("Username").fill("cseteacher1");
		page.getByLabel("Username").press("Tab");
		page.getByLabel("Password").fill("cseteacher1");
		page.getByLabel("Password").press("Enter");
	}

}
