/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.application;

import static org.assertj.core.api.Assertions.assertThat;

import nl.tudelft.labracore.api.dto.*;

import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;

import test.dev.DevLcDbLoader;
import test.dev.DevQueueApplication;
import test.labracore.*;
import test.nodb.NoDbTestQueueApplication;
import test.test.TestQueueApplication;

public class SmokeTest {
	static abstract class TestClass {
		@Autowired
		private HibernateProperties hp;

		@Test
		public void smoke() {
		}

		@Test
		void hibernateDdlIsSetCorrectly() {
			assertThat(hp.getDdlAuto()).isEqualTo(getExpectedDdl());
		}

		protected abstract String getExpectedDdl();
	}

	@Nested
	@SpringBootTest(classes = DevQueueApplication.class)
	@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
	public class DevelopmentApplicationWithValidateTest extends TestClass {
		@Autowired
		private DevLcDbLoader dev;

		@Override
		protected String getExpectedDdl() {
			return "validate";
		}
	}

	@Nested
	@SpringBootTest(classes = TestQueueApplication.class)
	@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
	public class TestApplicationTest extends TestClass {
		@Override
		protected String getExpectedDdl() {
			return "create-drop";
		}
	}

	@Nested
	@SpringBootTest(classes = NoDbTestQueueApplication.class)
	@DirtiesContext(classMode = DirtiesContext.ClassMode.BEFORE_CLASS)
	public class NoDbTestApplicationTest extends TestClass {
		@Override
		protected String getExpectedDdl() {
			return "create-drop";
		}
	}
}
