/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.controller;

import static org.assertj.core.api.Assertions.assertThat;
import static org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors.csrf;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.transaction.Transactional;

import nl.tudelft.queue.model.enums.Language;
import nl.tudelft.queue.repository.ProfileRepository;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.security.test.context.support.WithUserDetails;
import org.springframework.test.web.servlet.MockMvc;

import test.labracore.PersonApiMocker;
import test.test.TestQueueApplication;

@Transactional
@AutoConfigureMockMvc
@SpringBootTest(classes = TestQueueApplication.class)
public class ProfileControllerTest {

	@Autowired
	private MockMvc mvc;
	@Autowired
	private ProfileRepository profileRepository;
	@Autowired
	private PersonApiMocker pApiMocker;

	private ProfileController profileController;

	@BeforeEach
	void setUp() {
		profileController = new ProfileController(profileRepository);
	}

	@Test
	@WithUserDetails("teacher1")
	void updateProfile() throws Exception {
		var person = pApiMocker.getByUsername("teacher1").get();
		mvc.perform(post("/profile/update").with(csrf())
				.header("Content-Type", "application/json")
				.content("{\"language\": \"ENGLISH_ONLY\"}"))
				.andExpect(status().isOk());
		assertThat(profileRepository.findById(person.getId()).get().getLanguage())
				.isEqualTo(Language.ENGLISH_ONLY);
	}

}
