/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package test.dev;

import nl.tudelft.labracore.lib.LabracoreApiConfig;
import nl.tudelft.queue.QueueApplication;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

import test.BaseMockConfig;
import test.TestDatabaseLoader;
import test.TestUserDetailsService;
import test.labracore.LabracoreApiMocker;

@SpringBootApplication
@PropertySource("classpath:application-dev.properties")
@ComponentScan(basePackageClasses = LabracoreApiMocker.class)
@Import({
		BaseMockConfig.class,
		DevLcDbLoader.class,
		LabracoreApiConfig.class,
		TestDatabaseLoader.class,
		TestUserDetailsService.class
})
public class DevQueueApplication extends QueueApplication {
	/**
	 * Required field to make sure the DevLcDbLoader configuration is initialized before the DevDbLoader.
	 */
	@Autowired
	private DevLcDbLoader dev;
}
