/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2021  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package test.labracore;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

import lombok.AllArgsConstructor;
import lombok.Getter;
import nl.tudelft.labracore.api.EditionCollectionControllerApi;
import nl.tudelft.labracore.api.dto.EditionCollectionDetailsDTO;

@AllArgsConstructor
public class EditionCollectionApiMocker extends LabracoreApiMocker<EditionCollectionDetailsDTO, Long> {
	@Getter
	private final EditionCollectionControllerApi ecApi;

	@Override
	public void mock() {
		when(ecApi.getEditionCollectionsById(any())).thenAnswer(getAllByIds);
		when(ecApi.getEditionCollectionById(any())).thenAnswer(getOneByMap(data));
		when(ecApi.getEditionCollectionsByEdition(any())).thenAnswer(getOneByMap(data));
	}

	@Override
	public Long getId(EditionCollectionDetailsDTO dto) {
		return dto.getId();
	}
}
