/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.dto.create;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.*;
import nl.tudelft.labracore.api.dto.*;
import nl.tudelft.librador.dto.create.Create;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class QueueEditionCollectionCreateDTO extends Create<EditionCollectionCreateDTO> {

	@NotBlank
	private String name;

	@Size(min = 2)
	@Builder.Default
	private List<Long> editions = new ArrayList<>();

	@Override
	public Class<EditionCollectionCreateDTO> clazz() {
		return EditionCollectionCreateDTO.class;
	}

	@Override
	protected void postApply(EditionCollectionCreateDTO data) {
		data.editions(editions.stream().map(l -> new EditionIdDTO().id(l)).collect(Collectors.toSet()));
		super.postApply(data);
	}
}
