/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.dto.util;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

import lombok.*;
import nl.tudelft.queue.dto.create.QueueSessionCreateDTO;
import nl.tudelft.queue.model.QueueSession;
import nl.tudelft.queue.model.embeddables.Slot;
import nl.tudelft.queue.model.enums.QueueSessionType;
import nl.tudelft.queue.model.labs.CapacitySession;
import nl.tudelft.queue.model.labs.RegularLab;
import nl.tudelft.queue.model.labs.SlottedLab;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class ImportSessionDTO implements Serializable {

	private String name;
	private LocalDateTime start;
	private LocalDateTime end;
	private QueueSessionType sessionType;
	private Set<Long> roomIds;

	public QueueSessionCreateDTO<?> getCreateDTO() {
		QueueSessionCreateDTO<?> dto = this.sessionType.newCreateDto();
		dto.setName(name);
		dto.setSlot(new Slot(start, end));
		dto.setRooms(roomIds);
		return dto;
	}

	public QueueSession<?> getQueueSession() {
		return switch (sessionType) {
			case REGULAR -> new RegularLab();
			case SLOTTED -> new SlottedLab();
			case CAPACITY -> new CapacitySession();
			default -> throw new UnsupportedOperationException(("%s not supported for " +
					"getQueueSession").formatted(sessionType.name()));
		};
	}
}
