/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.repository;

import java.util.List;

import org.springframework.data.jpa.repository.Query;

import nl.tudelft.queue.model.labs.Lab;

public interface LabRepository extends QueueRepository<Lab, Long> {

	/**
	 * @param  sessions The ids of the sessions to find labs for.
	 * @return          The labs that are in the given sessions.
	 */
	@Query("select lab from Lab lab where lab.session in ?1")
	List<Lab> findAllBySessions(List<Long> sessions);

}
