/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import org.springframework.stereotype.Service;

import nl.tudelft.labracore.api.RoomControllerApi;
import nl.tudelft.labracore.api.SessionControllerApi;
import nl.tudelft.labracore.api.dto.SessionDetailsDTO;
import nl.tudelft.queue.dto.util.ImportSessionDTO;

@Service
public class ImportFromTimeTableService {

	private final SessionControllerApi sessionControllerApi;
	private final RoomControllerApi roomControllerApi;

	public ImportFromTimeTableService(SessionControllerApi sessionControllerApi,
			RoomControllerApi roomControllerApi) {
		this.sessionControllerApi = sessionControllerApi;
		this.roomControllerApi = roomControllerApi;
	}

	public List<SessionDetailsDTO> getImportSessionForEdition(Long editionId) {
		return this.sessionControllerApi.getSessionsFromMyTimeTable(editionId).collectList().block();
	}

	public SessionDetailsDTO convertToSessionDetailsDTO(ImportSessionDTO sessionDTO) {
		return new SessionDetailsDTO()
				.name(sessionDTO.getName())
				.start(sessionDTO.getStart())
				.endTime(sessionDTO.getEnd())
				.rooms(new HashSet<>(
						roomControllerApi.getAllRoomsById(new ArrayList<>(sessionDTO.getRoomIds()))
								.collectList().block()));
	}
}
