/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.service;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

import nl.tudelft.labracore.api.RoomControllerApi;
import nl.tudelft.labracore.api.SessionControllerApi;
import nl.tudelft.labracore.api.dto.RoomDetailsDTO;
import nl.tudelft.labracore.api.dto.SessionDetailsDTO;
import nl.tudelft.queue.dto.util.ImportSessionDTO;
import nl.tudelft.queue.model.enums.QueueSessionType;
import reactor.core.publisher.Flux;

public class ImportFromTimeTableServiceTest {

	ImportFromTimeTableService importFromTimeTableService;

	SessionControllerApi sessionControllerApi;
	RoomControllerApi roomControllerApi;

	@BeforeEach
	void setUp() {
		sessionControllerApi = Mockito.mock(SessionControllerApi.class);
		roomControllerApi = Mockito.mock(RoomControllerApi.class);
		importFromTimeTableService = new ImportFromTimeTableService(sessionControllerApi,
				roomControllerApi);
	}

	@Test
    void testConvertToSessionDetailsDTO() {
        when(roomControllerApi.getAllRoomsById(any())).thenReturn(Flux.fromIterable(List.of(new RoomDetailsDTO().name("TZ1").id(4L))));
        ImportSessionDTO dto = new ImportSessionDTO("TEST", LocalDateTime.now(),
                LocalDateTime.now().plusHours(1L), QueueSessionType.REGULAR, Set.of(4L));

        var rooms = new HashSet<RoomDetailsDTO>();
        rooms.add(new RoomDetailsDTO().name("TZ1").id(4L));
        assertThat(importFromTimeTableService.convertToSessionDetailsDTO(dto)).isEqualTo(new SessionDetailsDTO()
                .name("TEST")
                .start(dto.getStart())
                .endTime(dto.getEnd())
                .rooms(rooms));
    }

}
