/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
document.addEventListener("DOMContentLoaded", async () => {
    // Load all maps in elements with a 'data-room-id' attribute
    document.querySelectorAll("[data-room-id]").forEach(imageHolder => {
        loadMap(imageHolder);
    });

    // When a select with a 'data-update-map' attribute changes, update all the maps with a corresponding 'data-update-map' attribute
    document.querySelectorAll("[data-update-map]").forEach(select => {
        select.addEventListener("change", () => {
            const roomId = select.value;
            const mapId = select.getAttribute("data-update-map");
            document.querySelectorAll(`[data-map="${mapId}"]`).forEach(imageHolder => {
                imageHolder.setAttribute("data-room-id", roomId);
                loadMap(imageHolder);
            });
        });
    });
});

async function loadMap(imageHolder) {
    const image = imageHolder.querySelector("img");
    const roomId = imageHolder.getAttribute("data-room-id");
    try {
        const response = await fetch(`/room/map/${roomId}`);
        const fileName = (await response.json())["fileName"];
        image.setAttribute("src", `/maps/${fileName}`);
        imageHolder.removeAttribute("hidden");
    } catch (error) {
        // On error (most of the time 404, i.e. room has no image), hide the map
        imageHolder.setAttribute("hidden", "");
    }
}
