/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.service;

import static org.assertj.core.api.Assertions.assertThat;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.SpyBean;

import nl.tudelft.labracore.api.dto.CourseSummaryDTO;
import test.TestDatabaseLoader;
import test.labracore.EditionApiMocker;
import test.labracore.ModuleApiMocker;
import test.test.TestQueueApplication;

@SpringBootTest(classes = TestQueueApplication.class)
class AssignmentServiceTest {

	@Autowired
	private EditionApiMocker eApiMocker;

	@Autowired
	private ModuleApiMocker mApiMocker;

	@Autowired
	private TestDatabaseLoader db;

	@SpyBean
	private AssignmentService assignmentService;

	@BeforeEach
	void setUp() {
		eApiMocker.save(db.getRlNow());
		eApiMocker.mock();

		mApiMocker.save(db.getRlNowLabsModule());
		mApiMocker.mock();
	}

	@Test
	void testGetCourseByAssignment() {
		CourseSummaryDTO course = assignmentService.getCourseByAssignment(db.getRlNowAssignments()[0]);
		assertThat(course.getId()).isEqualTo(db.getRlNow().getCourse().getId());
	}

}
