/*
 * Queue - A Queueing system that can be used to handle labs in higher education
 * Copyright (C) 2016-2024  Delft University of Technology
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package nl.tudelft.queue.service;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import nl.tudelft.labracore.api.dto.AssignmentDetailsDTO;
import nl.tudelft.queue.dto.util.RequestTableFilterDTO;
import nl.tudelft.queue.model.LabRequest;
import test.TestDatabaseLoader;
import test.labracore.AssignmentApiMocker;
import test.labracore.EditionApiMocker;
import test.labracore.ModuleApiMocker;
import test.test.TestQueueApplication;

@SpringBootTest(classes = TestQueueApplication.class)
class RequestTableServiceTest {

	@Autowired
	private TestDatabaseLoader db;

	@Autowired
	private RequestTableService rts;

	@Autowired
	private ModuleApiMocker mApiMocker;

	@Autowired
	private AssignmentApiMocker aApiMocker;

	@Autowired
	private EditionApiMocker eApiMocker;

	private List<LabRequest> requests;

	@BeforeEach
	void setUp() {

		requests = new ArrayList<>(List.of(db.getOopNowRegularLab1Requests()));
		requests.addAll(List.of(db.getRlNowRegularLabRequests()));

		for (AssignmentDetailsDTO assignment : db.getRlNowAssignments()) {
			aApiMocker.save(assignment);
		}
		aApiMocker.mock();

		eApiMocker.save(db.getRlNow());
		eApiMocker.save(db.getOopNow());
		eApiMocker.mock();

		mApiMocker.save(db.getRlNowLabsModule());
		mApiMocker.save(db.getOopNowLabsModule());
		mApiMocker.mock();

	}

	@Test
	void testFilterByCourse() {
		RequestTableFilterDTO filter = new RequestTableFilterDTO();
		filter.setCourses(Set.of(db.getCourseRl().getId()));

		List<LabRequest> result = rts.filterByCourse(requests, filter, LabRequest::getAssignment);
		assertThat(result).containsAll(List.of(db.getRlNowRegularLabRequests()));
	}

}
